
set more off
use "JEAS 2021.dta", replace

drop if religion != 1

*===============================================================
* Regressions: Logistic Regression Interaction Analysis
*===============================================================

*** satisfaction ***************************
set more off
logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.feelchristians c.feeltionghoa c.satisfaction#c.feelchristians c.satisfaction#c.feeltionghoa
estimates store m1

*** shalat ***************************
set more off
logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.feelchristians c.feeltionghoa c.shalat c.shalat#c.feelchristians c.shalat#c.feeltionghoa
estimates store m2

*** tolerance ***************************
set more off
logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.feelchristians c.feeltionghoa c.tolelected c.tolelected#c.feelchristians c.tolelected#c.feeltionghoa
estimates store m3

*** sharia ***************************
set more off
logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.feelchristians c.feeltionghoa c.islamiclaw c.islamiclaw#c.feelchristians c.islamiclaw#c.feeltionghoa
estimates store m4

esttab m* using Table-A7.csv, b(3) se(2) starlevels(* .10 ** .05 *** .01) r2(3) nogaps replace
estimates clear


*===============================================================
* Plot Marginal Effect by Satisfaction 
*===============================================================

set more off
quiet: logit dvcorr female age edu income i.ethnicity i.pilgubknowledge c.satisfaction##c.feelchristians c.satisfaction##c.feeltionghoa
margins, dydx(feelchristians feeltionghoa) at(satisfaction=(2.15)) atmeans post
estimates store Low

set more off
quiet: logit dvcorr female age edu income i.ethnicity i.pilgubknowledge c.satisfaction##c.feelchristians c.satisfaction##c.feeltionghoa
margins, dydx(feelchristians feeltionghoa) at(satisfaction=(3.43)) atmeans post
estimates store High

coefplot Low, bylabel(Low Satisfaction) plotregion(ilcolor(black) margin(zero)) ///
		|| High, bylabel(High satisfaction) plotregion(ilcolor(black) margin(zero)) ///
		||, xtitle(" ") ///
			subtitle(, size(medium) color(white) bcolor(black)) ///
			xline(0, lpattern(solid) lwidth(thin))
graph export "Figure-4-Satisfaction.png", replace


*===============================================================
* Plot Marginal Effect by Shalat 
*===============================================================

set more off
quiet: logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.shalat##c.feelchristians c.shalat##c.feeltionghoa
margins, dydx(feelchristians feeltionghoa) at(shalat=(3.22)) atmeans post
estimates store Low

set more off
quiet: logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.shalat##c.feelchristians c.shalat##c.feeltionghoa
margins, dydx(feelchristians feeltionghoa) at(shalat=(5)) atmeans post
estimates store High

coefplot Low, bylabel(Low Religiosity) plotregion(ilcolor(black) margin(zero)) ///
		|| High, bylabel(High Religiosity)  plotregion(ilcolor(black) margin(zero)) ///
		||, xtitle(" ") ///
			subtitle(, size(medium) color(white) bcolor(black)) ///
			xline(0, lpattern(solid) lwidth(thin))
graph export "Figure-4-Shalat.png", replace



*===============================================================
* Plot Marginal Effect by Tolerance 
*===============================================================

set more off
quiet: logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.tolelected##c.feelchristians c.tolelected##c.feeltionghoa
margins, dydx(feelchristians feeltionghoa) at(tolelected=(1.73)) atmeans post
estimates store Low

set more off
quiet: logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.tolelected##c.feelchristians c.tolelected##c.feeltionghoa
margins, dydx(feelchristians feeltionghoa) at(tolelected=(3.09)) atmeans post
estimates store High

coefplot Low, bylabel(Low Tolerance) plotregion(ilcolor(black) margin(zero)) ///
		|| High, bylabel(High Tolerance)  plotregion(ilcolor(black) margin(zero)) ///
		||, xtitle(" ") ///
			subtitle(, size(medium) color(white) bcolor(black)) ///
			xline(0, lpattern(solid) lwidth(thin))
graph export "Figure-4-Tolerance.png", replace


*===============================================================
* Plot Marginal Effect by Support for Sharia 
*===============================================================

set more off
quiet: logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.islamiclaw##c.feelchristians c.islamiclaw##c.feeltionghoa
margins, dydx(feelchristians feeltionghoa) at(islamiclaw=(1.99)) atmeans post
estimates store Low

set more off
quiet: logit dvcorr female age edu income i.ethnicity i.pilgubknowledge satisfaction c.islamiclaw##c.feelchristians c.islamiclaw##c.feeltionghoa
margins, dydx(feelchristians feeltionghoa) at(islamiclaw=(3.41)) atmeans post
estimates store High

coefplot Low, bylabel(Low Support for Sharia) plotregion(ilcolor(black) margin(zero)) ///
		|| High, bylabel(High Support for Sharia)  plotregion(ilcolor(black) margin(zero)) ///
		||, xtitle(" ") ///
			subtitle(, size(medium) color(white) bcolor(black)) ///
			xline(0, lpattern(solid) lwidth(thin))
graph export "Figure-4-Sharia.png", replace

